﻿const express = require("express");
const fetch = require("node-fetch");
const router = express.Router();
const Joi = require("joi").extend(require("@joi/date"));
const validateRequest = require("../middleware/validate-request");
const authorize = require("../middleware/authorize");
const Role = require("../helpers/role");
const offreService = require("./offre.service");

//import fetch from 'node-fetch';

// routes

router.get("/", getAll);
router.get("/:id", getById);
router.post("/", authorize(), createSchema, create);
router.post("/dist", createDist);
router.put("/:id", authorize(), updateSchema, update);
router.delete("/:id", authorize(Role.Admin), _delete);

module.exports = router;

function getAll(req, res, next) {
  offreService
    .getAll()
    .then((offres) => res.json(offres))
    .catch(next);
}

function getById(req, res, next) {
  // users can get their own account and admins can get any account
  /*  if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
        return res.status(401).json({ message: 'Unauthorized' });
    }
    */

  offreService
    .getById(req.params.id)
    .then((offre) => (offre ? res.json(offre) : res.sendStatus(404)))
    .catch(next);
}

function createSchema(req, res, next) {
  const schema = Joi.object({
    status: Joi.string(),
    title: Joi.string().required(),
    publicationDate: Joi.date().format("YYYY-MM-DD").utc(),
    expirationDate: Joi.date().format("YYYY-MM-DD").utc(),
    nature: Joi.string().required(),
    type_contrat: Joi.string(),
    pays: Joi.string(),
    wilaya: Joi.string().required(),
    email_destinataire: Joi.string().allow('').optional(),
    jobTitle: Joi.string().required(),
    jobDescription: Joi.string().required(),
    requiredProfile: Joi.string(),
    autre: Joi.string().allow('').optional(),
    wp_id: Joi.number(),
  });
  validateRequest(req, next, schema);
}

async function create(req, res, next) {
  let wp_id = null;
  await offreService
    .createWP(req.body).then(function (response) {
      wp_id = response;
      return wp_id;
    });
  console.log('wp_id', wp_id);
  if (wp_id) {
    req.body.wp_id = wp_id;
  offreService
    .create(req.body)
    .then((offre) => res.json(offre))
    .catch(next);
  } else {
    res.json('probleme WP');
  }

}


function createDist(req, res, next) {
  console.log('createDist');


  offreService.createWP(req.body);
  /*
  .then((offre) => res.json(offre))
  .catch(next);
  */
}


function updateSchema(req, res, next) {
  const schemaRules = {
    status: Joi.string(),
    title: Joi.string().required(),
    publicationDate: Joi.date().format("YYYY-MM-DD").utc(),
    expirationDate: Joi.date().format("YYYY-MM-DD").utc(),
    nature: Joi.string().required(),
    type_contrat: Joi.string(),
    pays: Joi.string(),
    wilaya: Joi.string().required(),
    email_destinataire: Joi.string().allow('').optional(),
    jobTitle: Joi.string().required(),
    jobDescription: Joi.string().required(),
    requiredProfile: Joi.string(),
    autre: Joi.string().allow('').optional(),
  };

  // only admins can update role
  /*  if (req.user.role === Role.Admin) {
      schemaRules.role = Joi.string().valid(Role.Admin, Role.User).empty("");
    }*/

  const schema = Joi.object(schemaRules).with("password", "confirmPassword");
  validateRequest(req, next, schema);
}

function update(req, res, next) {
  // users can update their own offre and admins can update any offre
  /*
  if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
    return res.status(401).json({ message: "Unauthorized" });
  }*/

  offreService
    .update(req.params.id, req.body)
    .then((offre) => {
      console.log('updated', offre);
      offreService
        .updateWP(offre).then(function (response) {
          console.log('edit response', response)
        });
      res.json(offre)
    }
    )
    .catch(next);
}

function _delete(req, res, next) {
  // users can delete their own account and admins can delete any account
  if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
    return res.status(401).json({ message: "Unauthorized" });
  }

  offreService
    .delete(req.params.id)
    .then(() => res.json({ message: "Offre deleted successfully" }))
    .catch(next);
}
