﻿const config = require("../config.json");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");
const crypto = require("crypto");
const { Op } = require("sequelize");
const sendEmail = require("../helpers/send-email");
const db = require("../helpers/db");
const Role = require("../helpers/role");

const fetch = require("node-fetch");
const { post } = require("./offres.controller");

const { wp_username, wp_psw } = config.wp_account;

module.exports = {
  getAll,
  getById,
  create,
  createWP,
  update,
  updateWP,
  delete: _delete,
};

function basicDetails(offre) {
  const {
    id,
    status,
    title,
    publicationDate,
    expirationDate,
    nature,
    type_contrat,
    pays,
    wilaya,
    email_destinataire,
    jobTitle,
    jobDescription,
    requiredProfile,
    autre,
    wp_id,
  } = offre;
  return {
    id,
    status,
    title,
    publicationDate,
    expirationDate,
    nature,
    type_contrat,
    pays,
    wilaya,
    email_destinataire,
    jobTitle,
    jobDescription,
    requiredProfile,
    autre,
    wp_id,
  };
}

async function getAll() {
  const offres = await db.Offre.findAll();
  return offres.map((x) => basicDetails(x));
}

async function getById(id) {
  const offre = await getOffre(id);
  return basicDetails(offre);
}

async function create(params) {
  const offre = new db.Offre(params);
  // save offre
  await offre.save();

  return basicDetails(offre);
}

async function createWP(params) {
  const user = await fetch('https://cmconsulting-dz.com/wp-json/jwt-auth/v1/token', {
    method: "POST",
    headers: {
      'Content-Type': 'application/json',
      'accept': 'application/json',
    },

    body: JSON.stringify({
      username: wp_username,
      password: wp_psw
    })
  }).then(function (response) {
    return response.json()
  });

  //console.log('user', user.token);

  const add_offre = await fetch('https://cmconsulting-dz.com/wp-json/wp/v2/emplois', {
    method: "POST",
    headers: {
      'Content-Type': 'application/json',
      'accept': 'application/json',
      'Authorization': `Bearer ${user.token}`
    },
    body: JSON.stringify({
      date: params.publicationDate,
      title: params.jobTitle,
      content: '',
      status: 'pending',
      acf: {
        fiche_poste: { description: params.jobDescription, profil_recherche: params.requiredProfile, autre: params.autre },
        caracteristiques_poste: { location: params.wilaya, type_contrat: params.type_contrat, type_offre: params.nature, email_destinataire: params.email_destinataire, date_expiration: params.expirationDate }
      }
    })
  }).then(function (response) {
    return response.json()
  });
  // console.log('add_offre', add_offre.id);
  return add_offre.id
}



async function update(id, params) {
  const offre = await getOffre(id);
  // copy params to offre and save
  Object.assign(offre, params);
  offre.updated = Date.now();
  await offre.save();

  return basicDetails(offre);
}

async function updateWP(params) {
  const user = await fetch('https://cmconsulting-dz.com/wp-json/jwt-auth/v1/token', {
    method: "POST",
    headers: {
      'Content-Type': 'application/json',
      'accept': 'application/json',
    },

    body: JSON.stringify({
      username: wp_username,
      password: wp_psw
    })
  }).then(function (response) {
    return response.json()
  });

  console.log('user', user.token);
  console.log('params.wp_id', params.wp_id);
  console.log('status_params', params.status)
  const statusWP = params.status;
  const edit_offre = await fetch(`https://cmconsulting-dz.com/wp-json/wp/v2/emplois/${params.wp_id}`, {
    method: "POST",
    headers: {
      'Content-Type': 'application/json',
      'accept': 'application/json',
      'Authorization': `Bearer ${user.token}`
    },
    body: JSON.stringify({
      title: (statusWP == 'trash') ? params.jobTitle + ' [SUPPRIMER]' : params.jobTitle,
      content: '',
      status: (statusWP == 'trash') ? 'pending' : statusWP,
      acf: {
        fiche_poste: { description: params.jobDescription, profil_recherche: params.requiredProfile, autre: params.autre },
        caracteristiques_poste: { location: params.wilaya, type_contrat: params.type_contrat, type_offre: params.nature, email_destinataire: params.email_destinataire, date_expiration: params.expirationDate }
      }
    })
  }).then(function (response) {
    console.log('edit response in service', response)
    return response.json()
  });
  // console.log('edit_offre', edit_offre);
  return edit_offre.id
}

async function _delete(id) {
  const offre = await getOffre(id);
  await offre.destroy();
}

// helper functions

async function getOffre(id) {
  const offre = await db.Offre.findByPk(id);
  if (!offre) throw "Offre not found";
  return offre;
}


/****************************/
async function createWP__svg(params) {
  fetch('https://cmconsulting-dz.com/wp-json/jwt-auth/v1/token', {
    method: "POST",
    headers: {
      'Content-Type': 'application/json',
      'accept': 'application/json',
    },

    body: JSON.stringify({
      username: 'cvtheque',
      password: '&A3oG@VzXg9DCd%&Cv1lqbd&'
    })
  }).then(function (response) {
    console.log('auth', response.statusText);
    return response.json()
  }).then(function (user) {
    //console.log(user.token)
    fetch('https://cmconsulting-dz.com/wp-json/wp/v2/emplois', {
      method: "POST",
      headers: {
        'Content-Type': 'application/json',
        'accept': 'application/json',
        'Authorization': `Bearer ${user.token}`
      },
      body: JSON.stringify({
        date: params.publicationDate,
        title: params.jobTitle,
        content: '',
        status: 'pending',
        acf: {
          fiche_poste: { description: params.jobDescription, profil_recherche: params.requiredProfile, autre: params.autre },
          caracteristiques_poste: { location: params.wilaya, type_contrat: params.type_contrat, type_offre: params.nature, email_destinataire: params.email_destinataire }
        }
      })
    }).then(function (response) {
      console.log('add res', response.statusText)
      return response.json()
    }).then(function (post) {
      console.log('post id', post.id)
      return post.id;
    });

  });


  /*
  const offre = new db.Offre(params);
  // save offre
  await offre.save();
 
  return basicDetails(offre);
  */
}
