﻿const express = require("express");
const app = express();
const router = express.Router();
const Joi = require("joi").extend(require("@joi/date"));
const validateRequest = require("../middleware/validate-request");
const authorize = require("../middleware/authorize");
const Role = require("../helpers/role");
const candidatureService = require("./candidature.service");
//const fileUpload = require("express-fileupload");
const path = require("path");

const multer = require("multer");
//const upload = multer({ dest: "uploads/" });
var storage = multer.diskStorage({
  destination: function (req, file, cb) {
    cb(null, 'uploads/')
  },
  filename: function (req, file, cb) {
    cb(null, Date.now() + '-' + file.originalname)
    //cb(null, Date.now() + path.extname(file.originalname)) 
  }
})

var upload = multer({ storage: storage });

// routes
router.post("/stats", authorize(),getStats);
router.get("/", authorize(),getAll);
router.get("/status/",authorize(), getStatus);
router.get("/:id",authorize(), getById);
/*
app.use(
  fileUpload()
);
*/
router.post("/", upload.single("cv_file"), createSchema, create);
router.put("/:id", authorize(), updateSchema, update);
router.delete("/:id", authorize(Role.Admin), _delete);

module.exports = router;

function getStats(req, res, next) {
  const poste = req.body.poste;
  candidatureService
    .getStats(poste)
    .then((candidatures) => res.json(candidatures))
    .catch(next);
}

function getAll(req, res, next) {
  candidatureService
    .getAll()
    .then((candidatures) => res.json(candidatures))
    .catch(next);
}

function getStatus(req, res, next) {
  candidatureService
    .getAllStatus(req.query.status)
    .then((candidatures) => res.json(candidatures))
    .catch(next);
}

function getById(req, res, next) {
  // users can get their own account and admins can get any account
  /*  if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
          return res.status(401).json({ message: 'Unauthorized' });
      }
      */

  candidatureService
    .getById(req.params.id)
    .then((candidature) =>
      candidature ? res.json(candidature) : res.sendStatus(404)
    )
    .catch(next);
}

function createSchema(req, res, next) {
  console.log('bodySchema', req.body);
  console.log('fillle', req.file);
 const api_url = "https://api.cmconsulting-rh.com/uploads/";
  req.body.cv = api_url + req.file.filename;
  //req.body.cv = 'req.file.filename';

  const d = new Date();
  let month = d.getMonth();
  let year = d.getFullYear();
  req.body.month = month + 1;
  req.body.year = year;
  //console.log(typeof year);

  const schema = Joi.object({
    status: Joi.string(),
    mention: Joi.string(),
    designation: Joi.string().required(),
    nom: Joi.string().required(),
    prenom: Joi.string().required(),
    email: Joi.string().required(),
    pays: Joi.string().required(),
    ville: Joi.string(),
    poste: Joi.string().required(),
    cv: Joi.string().required(),
    mobilite_geographique: Joi.string(),
    disponibilite: Joi.string().optional(),
    origine: Joi.string().optional(),
    month: Joi.number().required(),
    year: Joi.number().required(),
  });
  validateRequest(req, next, schema);

}

function create(req, res, next) {
  console.log('body', req.body);

  candidatureService
    .create(req.body)
    .then((candidature) => res.json(candidature))
    .catch(next);

}

function updateSchema(req, res, next) {
  const schemaRules = {
    status: Joi.string(),
    mention: Joi.string(),
    designation: Joi.string().required(),
    nom: Joi.string().required(),
    prenom: Joi.string().required(),
    email: Joi.string().required(),
    pays: Joi.string().required(),
    ville: Joi.string(),
    poste: Joi.string().required(),
    cv: Joi.string().required(),
    mobilite_geographique: Joi.string(),
    disponibilite: Joi.string(),
    origine: Joi.string(),
  };




  const schema = Joi.object(schemaRules).with("password", "confirmPassword");
  validateRequest(req, next, schema);
}

function update(req, res, next) {
  // users can update their own account and admins can update any account
  /* if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
     return res.status(401).json({ message: "Unauthorized" });
   }*/

  candidatureService
    .update(req.params.id, req.body)
    .then((candidature) => res.json(candidature))
    .catch(next);
}

function _delete(req, res, next) {
  // users can delete their own account and admins can delete any account
  /* if (Number(req.params.id) !== req.user.id && req.user.role !== Role.Admin) {
     return res.status(401).json({ message: "Unauthorized" });
   }*/

  candidatureService
    .delete(req.params.id)
    .then(() => res.json({ message: "Offre deleted successfully" }))
    .catch(next);
}
