﻿const config = require("../config.json");
const jwt = require("jsonwebtoken");
const bcrypt = require("bcryptjs");
const crypto = require("crypto");
const { Op } = require("sequelize");
const sendEmail = require("../helpers/send-email");
const db = require("../helpers/db");
const Role = require("../helpers/role");

module.exports = {
  getStats,
  getAll,
  getAllStatus,
  getById,
  create,
  update,
  delete: _delete,
};

function basicDetails(candidature) {
  const { id, created,updated, status, mention,designation, nom, prenom, email,pays, ville, poste, cv, mobilite_geographique, disponibilite, origine} = candidature;
  return { id, created,updated, status, mention,designation, nom, prenom, email,pays, ville, poste, cv, mobilite_geographique, disponibilite, origine};
}



async function getStats(poste) {
  const all = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
  let candidatures = {};
  if (poste != 'all') {
    for (let i of all) {
      candidatures[i] = await db.Candidature.count(
        {
          where: {
            month: {
              [Op.eq]: i
            },
            year: {
              [Op.eq]: 2022
            },
            poste: {
              [Op.eq]: poste
            }
          }
        }
      );
    }
  } else {
    for (let i of all) {
      candidatures[i] = await db.Candidature.count(
        {
          where: {
            month: {
              [Op.eq]: i
            },
            year: {
              [Op.eq]: 2022
            }
          }
        }
      );
    }
  }


  return candidatures;
}

async function getAll() {
  const candidatures = await db.Candidature.findAll();
  return candidatures.map((x) => basicDetails(x));
}
async function getAllStatus(status) {
  const candidatures = await db.Candidature.findAll({
    where: {
      status: status
    }
  });
  return candidatures.map((x) => basicDetails(x));
}

async function getById(id) {
  const candidature = await getCandidature(id);
  return basicDetails(candidature);
}

async function create(params) {
  const candidature = new db.Candidature(params);
  // save candidature
  await candidature.save();

  return basicDetails(candidature);
}

async function update(id, params) {
  const candidature = await getCandidature(id);
  // copy params to candidature and save
  Object.assign(candidature, params);
  candidature.updated = Date.now();
  await candidature.save();

  return basicDetails(candidature);
}

async function _delete(id) {
  const candidature = await getCandidature(id);
  await candidature.destroy();
}

// helper functions

async function getCandidature(id) {
  const candidature = await db.Candidature.findByPk(id);
  if (!candidature) throw "Candidature not found";
  return candidature;
}
